/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.offline;

import dev.ftb.extendedexchange.offline.OfflineKnowledge;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class OfflineKnowledgeManager
extends SavedData {
    private static final String DATA_NAME = "extendedexchange:offline_emc";
    private final Map<UUID, BigInteger> pendingEMC = new HashMap<UUID, BigInteger>();
    private final Map<UUID, OfflineKnowledge> offlineKnowledgeMap = new HashMap<UUID, OfflineKnowledge>();
    private static OfflineKnowledgeManager instance;

    private OfflineKnowledgeManager() {
    }

    public static OfflineKnowledgeManager getInstance() {
        if (instance == null) {
            ServerLevel overworld = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
            if (overworld == null) {
                throw new IllegalStateException("Overworld not initialized!");
            }
            instance = (OfflineKnowledgeManager)overworld.m_8895_().m_164861_(OfflineKnowledgeManager::load, OfflineKnowledgeManager::new, DATA_NAME);
        }
        return instance;
    }

    private static OfflineKnowledgeManager load(CompoundTag tag) {
        OfflineKnowledgeManager manager = new OfflineKnowledgeManager();
        CompoundTag sub = tag.m_128469_("EMC");
        for (String k : sub.m_128431_()) {
            UUID id = UUID.fromString(k);
            manager.pendingEMC.put(id, new BigInteger(sub.m_128461_(k)));
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag sub = new CompoundTag();
        this.offlineKnowledgeMap.forEach((id, knowledge) -> sub.m_128359_(id.toString(), knowledge.getEmc().toString()));
        compoundTag.m_128365_("EMC", (Tag)sub);
        return compoundTag;
    }

    public IKnowledgeProvider getKnowledgeProviderFor(Level level, UUID id) {
        if (level.f_46443_) {
            return null;
        }
        if (level.m_142572_() != null) {
            ServerPlayer player = level.m_142572_().m_6846_().m_11259_(id);
            if (player != null) {
                return this.getOnlineProvider((Player)player);
            }
            return this.getOfflineProvider(id);
        }
        return null;
    }

    @Nullable
    private OfflineKnowledge getOfflineProvider(UUID id) {
        OfflineKnowledge knowledge = this.offlineKnowledgeMap.get(id);
        if (knowledge != null) {
            return knowledge;
        }
        OfflineKnowledge newKnowledge = OfflineKnowledge.forPlayerId(id);
        if (newKnowledge != null) {
            if (this.pendingEMC.containsKey(id)) {
                newKnowledge.setEmc(this.pendingEMC.get(id));
                this.pendingEMC.remove(id);
            }
            this.offlineKnowledgeMap.put(id, newKnowledge);
        }
        return newKnowledge;
    }

    @Nullable
    private IKnowledgeProvider getOnlineProvider(Player player) {
        try {
            return (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NoSuchElementException::new);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void onEmcChanged() {
        this.m_77762_();
    }

    private void onPlayerConnect(Player player, IKnowledgeProvider handler) {
        UUID id = player.m_142081_();
        if (this.offlineKnowledgeMap.containsKey(id)) {
            handler.setEmc(this.offlineKnowledgeMap.get(id).getEmc());
            this.offlineKnowledgeMap.remove(id);
        } else if (this.pendingEMC.containsKey(id)) {
            handler.setEmc(this.pendingEMC.get(id));
            this.pendingEMC.remove(id);
            this.m_77762_();
        }
    }

    @Mod.EventBusSubscriber(modid="extendedexchange")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getPlayer().f_19853_.m_5776_()) {
                event.getPlayer().getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(handler -> OfflineKnowledgeManager.getInstance().onPlayerConnect(event.getPlayer(), (IKnowledgeProvider)handler));
            }
        }
    }
}

